function [ima]=ima_read(FileName,MachineFormat)
% [ima]=ima_read(FileName,MachineFormat)
% Input:
%  FileName:
%  MachineFormat:
% Output:
%  ima: a structure variable
%  ima.hdr
%  ima.img
VERBOSE=0;
%check input arguments
if(nargin<1),
    fprintf('Error:no FileName.\n');
    return;
end

if(nargin<2),
  if(VERBOSE==1),
    fprintf('no MachineFormat. set MachineFormat to ieee-be\n');
  end
  MachineFormat='ieee-be';
end

%add extension if necessary
[Path,File,Ext]=fileparts(FileName);
if(isempty(Ext)),
    fprintf('no extension specified, append extension for user.\n');
    FileName=[FileName '.ima'];
end

fid = fopen(FileName,'rb',MachineFormat);
if fid < 0,
    fprintf(['Error: Can not open ' FileName '\n']);
    return;
end

%creat ima structure
ima=struct('FileName',[],'hdr',[],'img',[]);
ima.FileName=FileName;
ima.hdr=ima_hdr_read(fid);
ima.img=ima_img_read(fid);

fclose(fid);

return

%=============================================================================
function [hdr] = ima_hdr_read(fid)
%hdr_format={'StartByte','SizeInPrecision','Precision','FieldName'}
StartByte=1; Size=2; Precision=3; FieldName=4;
hdr_format=...
{
768,25,'char','PatientName';...
1544,1,'double','PatientName';...
1560,1,'double','RepetitionTime';...
3083,8,'char','SequenceType';...
3744,1,'double','FOVRow';...             
3752,1,'double','FOVColumn';... 
4004,1,'uint32','nSlices';...
4136,1,'double','GapRatio';...
5000,1,'double','PixelSizeRow';...             
5008,1,'double','PixelSizeColumn';...
};


hdr=[];
nFields=size(hdr_format,1);

for i=1:nFields,
  fseek(fid,hdr_format{i,StartByte},'bof');
  value=fread(fid,hdr_format{i,Size},hdr_format{i,Precision});
  if(strcmp(hdr_format{i,Precision},'char')==1),
      value=char(value);
  end
  hdr=setfield(hdr,hdr_format{i,FieldName},value);
end


return


%========================================================================
function [img]=ima_img_read(fid)
%
ima_hdr_size=6144;
Precision = 'uint16';%!!!!!!!!!!!!!!!!!!!!!!!!!!!!
fseek(fid,ima_hdr_size,'bof');
img = fread(fid,inf,Precision);
return
